definition module osbitmap

//	Clean object I/O library, version 1.0.2

import ospicture

::	Bitmap
::	OSBitmap

toBitmap	:: !OSBitmap -> Bitmap
fromBitmap	:: !Bitmap -> OSBitmap

//	OSreadBitmap reads a bitmap from a file. See page 176 of Programming Windows 95 (Charles Petzold)
OSreadBitmap :: !*File -> (!Bool,!OSBitmap,!*File)

//	OSgetBitmapSize returns the size of the bitmap
OSgetBitmapSize :: !OSBitmap -> (!Int,!Int)

//	OSgetBitmapContent returns the content string of the bitmap
OSgetBitmapContent :: !OSBitmap -> {#Char}

/*	OSresizeBitmap bitmap (w,h) 
		resizes the argument bitmap to the given size.
		It is assumed that w and h are not negative.
*/
OSresizeBitmap :: !(!Int,!Int) !OSBitmap -> OSBitmap

/*	OSdrawBitmap bitmap pos origin pictContext
		draws the argument bitmap with the left top corner at pos, given the current origin and drawing context.
*/
OSdrawBitmap :: !OSBitmap !(!Int,!Int) !(!Int,!Int) !OSPictContext !*OSToolbox -> (!OSPictContext,!*OSToolbox)
